/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.solaris;

import com.sun.jna.Native;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.SolarisLibc;
import oshi.software.os.OSSession;
import oshi.util.Util;

@ThreadSafe
public final class Who {
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> arrayList = new ArrayList<OSSession>();
        LIBC.setutxent();
        try {
            SolarisLibc.SolarisUtmpx solarisUtmpx;
            while ((solarisUtmpx = LIBC.getutxent()) != null) {
                if (solarisUtmpx.ut_type != 7 && solarisUtmpx.ut_type != 6) continue;
                String string = Native.toString(solarisUtmpx.ut_user, StandardCharsets.US_ASCII);
                String string2 = Native.toString(solarisUtmpx.ut_line, StandardCharsets.US_ASCII);
                String string3 = Native.toString(solarisUtmpx.ut_host, StandardCharsets.US_ASCII);
                long l = solarisUtmpx.ut_tv.tv_sec.longValue() * 1000L + solarisUtmpx.ut_tv.tv_usec.longValue() / 1000L;
                if (!Util.isSessionValid(string, string2, l)) {
                    List<OSSession> list = oshi.driver.unix.Who.queryWho();
                    return list;
                }
                arrayList.add(new OSSession(string, string2, l, string3));
            }
        }
        finally {
            LIBC.endutxent();
        }
        return arrayList;
    }
}

