/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.platform.mac.SystemB;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.mac.Who;
import oshi.driver.mac.WindowInfo;
import oshi.jna.Struct;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.ApplicationInfo;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSDesktopWindow;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OSThread;
import oshi.software.os.OperatingSystem;
import oshi.software.os.mac.MacFileSystem;
import oshi.software.os.mac.MacInstalledApps;
import oshi.software.os.mac.MacInternetProtocolStats;
import oshi.software.os.mac.MacNetworkParams;
import oshi.software.os.mac.MacOSProcess;
import oshi.software.os.mac.MacOSThread;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.Util;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MacOperatingSystem.class);
    public static final String MACOS_VERSIONS_PROPERTIES = "oshi.macos.versions.properties";
    private static final String SYSTEM_LIBRARY_LAUNCH_AGENTS = "/System/Library/LaunchAgents";
    private static final String SYSTEM_LIBRARY_LAUNCH_DAEMONS = "/System/Library/LaunchDaemons";
    private int maxProc = 1024;
    private final String osXVersion;
    private final int major;
    private final int minor;
    private final Supplier<List<ApplicationInfo>> installedAppsSupplier = Memoizer.memoize(MacInstalledApps::queryInstalledApps, Memoizer.installedAppsExpiration());
    private static final long BOOTTIME;

    public MacOperatingSystem() {
        String string = System.getProperty("os.version");
        int n = ParseUtil.getFirstIntValue(string);
        int n2 = ParseUtil.getNthIntValue(string, 2);
        if (n == 10 && n2 > 15) {
            String string2 = ExecutingCommand.getFirstAnswer("sw_vers -productVersion");
            if (!string2.isEmpty()) {
                string = string2;
            }
            n = ParseUtil.getFirstIntValue(string);
            n2 = ParseUtil.getNthIntValue(string, 2);
        }
        this.osXVersion = string;
        this.major = n;
        this.minor = n2;
        this.maxProc = SysctlUtil.sysctl("kern.maxproc", 4096);
    }

    @Override
    public String queryManufacturer() {
        return "Apple";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String string = this.major > 10 || this.major == 10 && this.minor >= 12 ? "macOS" : System.getProperty("os.name");
        String string2 = this.parseCodeName();
        String string3 = SysctlUtil.sysctl("kern.osversion", "");
        return new Pair<String, OperatingSystem.OSVersionInfo>(string, new OperatingSystem.OSVersionInfo(this.osXVersion, string2, string3));
    }

    private String parseCodeName() {
        Properties properties = FileUtil.readPropertiesFromFilename(MACOS_VERSIONS_PROPERTIES);
        String string = null;
        if (this.major > 10) {
            string = properties.getProperty(Integer.toString(this.major));
        } else if (this.major == 10) {
            string = properties.getProperty(this.major + "." + this.minor);
        }
        if (Util.isBlank(string)) {
            LOG.warn("Unable to parse version {}.{} to a codename.", (Object)this.major, (Object)this.minor);
        }
        return string;
    }

    @Override
    protected int queryBitness(int n) {
        if (n == 64 || this.major == 10 && this.minor > 6) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("getconf LONG_BIT"), 32);
    }

    @Override
    public FileSystem getFileSystem() {
        return new MacFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new MacInternetProtocolStats(this.isElevated());
    }

    @Override
    public List<OSSession> getSessions() {
        return USE_WHO_COMMAND ? super.getSessions() : Who.queryUtxent();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        int[] nArray = new int[this.maxProc];
        Arrays.fill(nArray, -1);
        int n = SystemB.INSTANCE.proc_listpids(1, 0, nArray, nArray.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i = 0; i < n; ++i) {
            OSProcess oSProcess;
            if (nArray[i] < 0 || (oSProcess = this.getProcess(nArray[i])) == null) continue;
            arrayList.add(oSProcess);
        }
        return arrayList;
    }

    @Override
    public OSProcess getProcess(int n) {
        MacOSProcess macOSProcess = new MacOSProcess(n, this.major, this.minor, this);
        return macOSProcess.getState().equals((Object)OSProcess.State.INVALID) ? null : macOSProcess;
    }

    @Override
    public List<OSProcess> queryChildProcesses(int n) {
        List<OSProcess> list = this.queryAllProcesses();
        Set<Integer> set = MacOperatingSystem.getChildrenOrDescendants(list, n, false);
        return list.stream().filter(oSProcess -> set.contains(oSProcess.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int n) {
        List<OSProcess> list = this.queryAllProcesses();
        Set<Integer> set = MacOperatingSystem.getChildrenOrDescendants(list, n, true);
        return list.stream().filter(oSProcess -> set.contains(oSProcess.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return SystemB.INSTANCE.proc_listpids(1, 0, null, 0) / SystemB.INT_SIZE;
    }

    @Override
    public int getThreadId() {
        OSThread oSThread = this.getCurrentThread();
        if (oSThread == null) {
            return 0;
        }
        return oSThread.getThreadId();
    }

    @Override
    public OSThread getCurrentThread() {
        return this.getCurrentProcess().getThreadDetails().stream().sorted(Comparator.comparingLong(OSThread::getStartTime)).findFirst().orElse(new MacOSThread(this.getProcessId()));
    }

    @Override
    public int getThreadCount() {
        int[] nArray = new int[this.getProcessCount() + 10];
        int n = SystemB.INSTANCE.proc_listpids(1, 0, nArray, nArray.length) / SystemB.INT_SIZE;
        int n2 = 0;
        try (Struct.CloseableProcTaskInfo closeableProcTaskInfo = new Struct.CloseableProcTaskInfo();){
            for (int i = 0; i < n; ++i) {
                int n3 = SystemB.INSTANCE.proc_pidinfo(nArray[i], 4, 0L, closeableProcTaskInfo, closeableProcTaskInfo.size());
                if (n3 == -1) continue;
                n2 += closeableProcTaskInfo.pti_threadnum;
            }
        }
        return n2;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new MacNetworkParams();
    }

    @Override
    public List<OSService> getServices() {
        Object object;
        ArrayList<OSService> arrayList = new ArrayList<OSService>();
        HashSet<String> hashSet = new HashSet<String>();
        for (OSProcess object22 : this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0)) {
            object = new OSService(object22.getName(), object22.getProcessID(), OSService.State.RUNNING);
            arrayList.add((OSService)object);
            hashSet.add(object22.getName());
        }
        ArrayList arrayList2 = new ArrayList();
        File file2 = new File(SYSTEM_LIBRARY_LAUNCH_AGENTS);
        if (file2.exists() && file2.isDirectory()) {
            arrayList2.addAll(Arrays.asList(file2.listFiles((file, string) -> string.toLowerCase(Locale.ROOT).endsWith(".plist"))));
        } else {
            LOG.error("Directory: /System/Library/LaunchAgents does not exist");
        }
        File file3 = new File(SYSTEM_LIBRARY_LAUNCH_DAEMONS);
        if (file3.exists() && file3.isDirectory()) {
            arrayList2.addAll(Arrays.asList(file3.listFiles((file, string) -> string.toLowerCase(Locale.ROOT).endsWith(".plist"))));
        } else {
            LOG.error("Directory: /System/Library/LaunchDaemons does not exist");
        }
        object = arrayList2.iterator();
        while (object.hasNext()) {
            String string2;
            File file4 = (File)object.next();
            String string3 = file4.getName().substring(0, file4.getName().length() - 6);
            int n = string3.lastIndexOf(46);
            String string4 = string2 = n < 0 || n > string3.length() - 2 ? string3 : string3.substring(n + 1);
            if (hashSet.contains(string3) || hashSet.contains(string2)) continue;
            OSService oSService = new OSService(string3, 0, OSService.State.STOPPED);
            arrayList.add(oSService);
        }
        return arrayList;
    }

    @Override
    public List<OSDesktopWindow> getDesktopWindows(boolean bl) {
        return WindowInfo.queryDesktopWindows(bl);
    }

    @Override
    public List<ApplicationInfo> getInstalledApplications() {
        return this.installedAppsSupplier.get();
    }

    static {
        try (Struct.CloseableTimeval closeableTimeval = new Struct.CloseableTimeval();){
            BOOTTIME = !SysctlUtil.sysctl("kern.boottime", closeableTimeval) || closeableTimeval.tv_sec.longValue() == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : closeableTimeval.tv_sec.longValue();
        }
    }
}

